jQuery(document).ready(function ($) {
    var postType = $('#post_type').val(); // Obtener el tipo de post desde el formulario (CSS o JS)
    var editorElement = document.getElementById("code_snippet_content");

    // Verifica si el elemento del textarea existe antes de inicializar CodeMirror
    if (editorElement) {
        // Oculta el textarea original y prepara el fade-in
        $(editorElement).css('visibility', 'hidden');

        // Obtiene el tema desde las opciones de configuración pasadas por PHP
        var selectedTheme = codeSnippetManagerSettings.theme || "blackboard"; // Tema por defecto si no se ha seleccionado

        // Inicializa CodeMirror con el modo adecuado
        var mode = postType === 'css_snippet' ? "css" : "javascript";
        var editor = CodeMirror.fromTextArea(editorElement, {
            mode: mode, // Modo dinámico según el tipo de post
            lineNumbers: true,
            theme: selectedTheme, // Aplica el tema seleccionado
            lineWrapping: true,
            
        });

        // Ajusta el tamaño inicial del editor
        editor.setSize("100%", "300px");

        // Aplica animación fade-in al wrapper de CodeMirror
        var editorWrapper = $(editor.getWrapperElement());
        editorWrapper.css({ 
            opacity: 0, 
            visibility: 'visible', 
            resize: 'vertical', // Habilitar redimensionamiento
            overflow: 'auto' // Asegurar scroll cuando sea necesario
        }); 
        editorWrapper.animate({ opacity: 1 }, 800); // Animación de fade-in (800ms)

    } else {
        console.error("Textarea for CodeMirror not found!");
    }
});



(function($) {
    $(document).ready(function() {
        
      
  
       //estilos de editor codemirror
  
        console.log("javascriptFuncionando dentro de jq");
        var textareas = document.getElementsByClassName('codemirror-textarea-admin');
        Array.prototype.forEach.call(textareas, function(textarea) {
          var mode = textarea.getAttribute('data-mode');
          var editor = CodeMirror.fromTextArea(textarea, {
            lineNumbers: true,
            mode: mode,
            theme: "blackboard"
            // Agrega otras opciones de configuración según tus necesidades
          });
        });
  
  
  
      });
  })( jQuery );
  